#ifndef _EDITOR_
#define _EDITOR_

#include "DRKAddOns.h"
#include "ui.h"

// This was reverse engineered from various
// APPI resources seen. I'm not 100% sure of
// its structure. In particular, I do not know what
// the last 4 bytes of the APPI resource is all about
typedef struct APPIHeader
{
	ulong	app_type;
	long	flags;
	long	type_count;
};

// The editor class that implements the ADNI editor
class APPIEditor : public DRKEditor
{
public:
	APPIEditor(BResourceFile* resFile, long id);
virtual	~APPIEditor();

// We have to implement the following functions
virtual void	Activate();
virtual	bool	Modified();
virtual	void	Save();
virtual void	Close();
virtual bool	CloseRequested();

// We don't have to implement NotifyInfoChange but should		
virtual	void	NotifyInfoChange();

private:
		void	UpdateInfo();
		void	SetupWindow();

	APPIWindow		*fWindow;
	BListView		*fTypesList;
	BCheckBox		*fBkgndApp;
	BCheckBox		*fArgvOnly;
	BRadioButton	*fSinglLaunch;
	BRadioButton	*fMultiLaunch;
	BRadioButton	*fExcluLaunch;	
	BTextView		*fAppType;

	APPIHeader	*fOriginal;
	APPIHeader	*fModified;
	long		fSize;
};

#endif // _EDITOR_